<?php

namespace Database\Seeders;

use App\Models\Admin;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class AdminsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        
        Admin::upsert([
            [
                'name' => 'Developer Admin',
                'email' => 'developer@example.com',
                'email_verified_at' => now(),
                'password' => bcrypt('developer@spaceo'),
                'remember_token' => Str::random(10),
            ],
            [
                'name' => 'Admin',
                'email' => 'admin@example.com',
                'email_verified_at' => now(),
                'password' => bcrypt('admin@spaceo'),
                'remember_token' => Str::random(10),
            ]
        ], ['email'], ['name']);

        $admins = Admin::query()
                ->whereIn('email', ['developer@example.com', 'admin@example.com'])
                ->select('id', 'email')
                ->get();
        
        $admins->first(function($user) {
            return $user->email === 'developer@example.com';
        })->assignRole('developer');

        $admins->first(function($user) {
            return $user->email === 'admin@example.com';
        })->assignRole('super admin');
    }
}
