<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use SpaceO\RESTAuth\RESTAuth;

class AdminSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        RESTAuth::$settingModel::updateOrCreate(
            ['key' => RESTAuth::$settingModel::WAITING], // Conditions to check
            [
                'key' => RESTAuth::$settingModel::WAITING,
                'values' => [
                    'waiting_time' => 5,
                    'waiting_charge' => 10,
                ],
            ] // Data to be updated or inserted
        );

        RESTAuth::$settingModel::updateOrCreate(
            ['key' => RESTAuth::$settingModel::RADIUS], // Conditions to check
            [
                'key' => RESTAuth::$settingModel::RADIUS,
                'values' => [
                    'radius' => 5,
                ],
            ] // Data to be updated or inserted
        );

        RESTAuth::$settingModel::updateOrCreate(
            ['key' => RESTAuth::$settingModel::CANCELLATION], // Conditions to check
            [
                'key' => RESTAuth::$settingModel::CANCELLATION,
                'values' =>  [
                    'cancellation_time' => 5,
                    'cancellation_charge' => 10,
                ]
            ] // Data to be updated or inserted
        );
    }
}
