<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('air_transport_booking_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('air_transportation_id')->nullable()->constrained('air_transportations')->cascadeOnDelete();
            $table->foreignId('air_booking_id')->nullable()->constrained('air_transportation_bookings')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('air_transport_booking_requests');
    }
};
