<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('phone_assignments', function (Blueprint $table) {
            $table->id();
            $table->string('mask_number');
            $table->tinyInteger('status')->default(0)->comment('completed= 0,inprogress= 1,ringing= 2,busy= 3,failed= 4,noanswer= 5');
            $table->unsignedInteger('from_user_id')->nullable()->length(10);
            $table->unsignedInteger('to_user_id')->nullable()->length(10);    
            $table->timestamp('call_start_time')->nullable();
            $table->timestamp('call_end_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('phone_assignments');
    }
};
