<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('air_transportations', function (Blueprint $table) {
            $table->tinyInteger('request_status')->default(0)->comment("0=pending,1=accept,2=reject")->after('is_active');
            $table->longText('reason')->after('request_status')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('air_transportations', function (Blueprint $table) {
            //
        });
    }
};
