<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jet_images', function (Blueprint $table) {
            $table->id();
            $table->foreignId('jet_id')->references('id')->on('jets')->onDelete('cascade');
            $table->string('jet_image');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jet_images');
    }
};
