<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jets', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 36)->nullable();
            $table->foreignId('air_transportation_id')->nullable()->constrained('air_transportations')->cascadeOnDelete();
            $table->string('jet_name')->nullable();
            $table->integer('routing_type')->nullable();
            $table->integer('total_capacity');
            $table->integer('jet_type')->nullable();
            $table->tinyInteger('is_active')->unsigned()->default(1)->comment('1 = Active, 2 = Inactive');
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jets');
    }
};
