<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cancel_bookings', function (Blueprint $table) {
            $table->foreignId('air_transportation_booking_id')->after('booking_id')->nullable()->constrained('air_transportation_bookings')->cascadeOnDelete();
            $table->unsignedBigInteger('booking_id')->nullable()->change();
            $table->string('type')->after('cancelled_by')->nullable(); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cancel_bookings', function (Blueprint $table) {
            //
        });
    }
};
