<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Drop the foreign key constraint
        Schema::table('user_subscriptions', function (Blueprint $table) {
            $table->dropForeign(['subscription_id']);
        });

        // Drop the existing subscription_id column
        Schema::table('user_subscriptions', function (Blueprint $table) {
            $table->dropColumn('subscription_id');
        });

        // Add the new subscription_id column with string data type
        Schema::table('user_subscriptions', function (Blueprint $table) {
            $table->string('subscription_id')->after('subscribable_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_subscriptions', function (Blueprint $table) {
            $table->string('subscription_id');
        });
    }
};
