<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->string('notification_title', 100);
            $table->string('notification_desc', 255);
            $table->integer('notification_object_id')->nullable();
            $table->string('notification_object_type')->nullable();
            $table->string('notification_icon')->nullable();
            $table->string('sender_id', 100)->nullable();
            $table->string('receiver_id', 100)->nullable();
            $table->string('sender_type', 100)->nullable();
            $table->string('receiver_type', 100)->nullable();
            $table->tinyInteger('type')->unsigned()->comment("1=customer, 2=driver, 3=airtransport");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
