<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->string('subscription_name', 100);
            $table->tinyInteger('duration');
            $table->string('duration_type', 10);
            $table->decimal('price', 10, 2);
            $table->string('subscription_type', 10)->comment("1=taxi,2=airlines");
            $table->unsignedTinyInteger('is_active')->default(1)->comment("1=Active,0=Inactive");
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
