<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropForeign(['cancel_reason_id']);
            $table->dropColumn('cancel_reason_id');
            $table->dropColumn('cancel_description');
            $table->decimal('booking_amount', 10, 2)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->foreignId('cancel_reason_id')->nullable()->constrained('cancel_reasons')->cascadeOnDelete();
            $table->text('cancel_description')->nullable();
        });
    }
};
