<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quotes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('air_transportation_booking_id')->constrained('air_transportation_bookings')->cascadeOnDelete();
            $table->foreignId('air_transportation_id')->constrained('air_transportations')->cascadeOnDelete();
            $table->decimal('company_quote_price', 10, 2);
            $table->decimal('user_quote_price', 10, 2)->nullable();
            $table->datetime('quote_date_time');
            $table->tinyInteger('quote_status')->comment("1=accept, 2=counter, 3=reject");
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotes');
    }
};
