<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('air_transportation_bookings', function (Blueprint $table) {
            $table->id();
            $table->string('booking_no', 100);
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('air_transportation_id')->nullable()->constrained('air_transportations')->cascadeOnDelete();
            $table->string('pickup_location', 100);
            $table->string('dropoff_location', 100);
            $table->datetime('departure_date_time');
            $table->datetime('arrival_date_time')->nullable();
            $table->string('flying_type', 25);
            $table->text('comment')->nullable();
            $table->integer('adult');
            $table->integer('child');
            $table->integer('infants');
            $table->string('cancel_reason',255)->nullable();
            $table->tinyInteger('trip_type')->comment('1=one way trip , 2=round trip');
            $table->tinyInteger('status')->comment('1=pending,2=upcoming,3=completed,4=cancelled');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('air_transportation_bookings');
    }
};
