<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('air_transportations', function (Blueprint $table) {
            $table->id();
            $table->string('uuid');
            $table->string('first_name', 255);
            $table->string('last_name', 255);
            $table->string('email', 255);
            $table->string('password',60);
            $table->string('isd_code', 5);
            $table->string('mobile', 11);
            $table->string('company_name', 100)->nullable();
            $table->string('company_hq', 100)->nullable();
            $table->string('company_address', 255)->nullable();
            $table->string('company_contact', 11)->nullable();
            $table->string('company_url', 100)->nullable();
            $table->integer('mobile_otp', false)->unsigned()->nullable();
            $table->timestamp('mobile_otp_expired_at')->nullable();
            $table->timestamp('mobile_verified_at')->nullable();
            $table->string('profile_image', 100)->nullable();
            $table->string('sendbird_chat_id', 100);
            $table->string('stripe_id', 100);
            $table->tinyInteger('type')->comment('1=company, 2=individual');
            $table->string('remember_token', 100)->nullable();
            $table->tinyInteger('is_active')->unsigned()->default(1);
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('air_transportations');
    }
};
