<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('drivers', function (Blueprint $table) {
            $table->dropColumn('otp_expiry_date');
            $table->renameColumn('otp', 'mobile_otp');
            $table->timestamp('mobile_otp_expired_at')->after('otp')->nullable();
            $table->timestamp('mobile_verified_at')->after('otp')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('drivers', function (Blueprint $table) {
            $table->dateTime('otp_expiry_date')->nullable();
            $table->renameColumn('mobile_otp', 'otp');
        });
    }
};
