<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicle_infos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('driver_id')->constrained('drivers')->cascadeOnDelete();
            $table->tinyInteger('vehicle_type')->nullable();
            $table->string('plate_number', 100)->nullable();
            $table->string('model_name', 50)->nullable();
            $table->string('model_no', 100)->nullable();
            $table->string('color', 20)->nullable();
            $table->string('identification_no', 100)->nullable();
            $table->integer('model_year')->nullable();
            $table->integer('seating_capacity')->nullable();
            $table->string('registration_proof_file', 100)->nullable();
            $table->string('insurance_proof_file', 100)->nullable();
            $table->string('vehicle_front_image', 100)->nullable();
            $table->string('vehicle_back_image', 100)->nullable();
            $table->string('vehicle_right_image', 100)->nullable();
            $table->string('vehicle_left_image', 100)->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicle_infos');
    }
};
