<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->uuid('uuid')->after('id');
            $table->date('dob')->nullable()->after('username');
            $table->tinyInteger('gender')->nullable()->unsigned()->after('username')->comment('1=Male, 2=Female, 3=Prefer not to say');
            $table->string('sendbird_chat_id',100)->nullable()->after('profile_photo');
            $table->string('stripe_id',100)->nullable()->after('profile_photo');
            $table->tinyInteger('push_notification_accept')->unsigned()->after('profile_photo')->default(0)->comment('1=Accepted, 2=Not Accepted');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['uuid', 'dob', 'gender', 'sendbird_chat_id', 'stripe_id', 'push_notification_accept']);
        });
    }
};
