<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->string('booking_no', 100);
            $table->foreignId('driver_id')->nullable()->constrained('drivers')->cascadeOnDelete();
            $table->datetime('booking_date_time');
            $table->integer('booking_status');
            $table->foreignId('car_id')->nullable()->constrained('cars')->cascadeOnDelete();
            $table->tinyInteger('is_scheduled')->unsigned()->default(0)->comment('1 = Yes, 0 = No');
            $table->date('schedule_date', 10)->nullable();
            $table->string('schedule_time', 10)->nullable();
            $table->foreignId('promocode_id')->nullable()->constrained('promocodes')->cascadeOnDelete();
            $table->decimal('promocode_amount', 10, 2)->nullable();
            $table->decimal('booking_amount', 10, 2);
            $table->foreignId('cancel_reason_id')->nullable()->constrained('cancel_reasons')->cascadeOnDelete();
            $table->text('cancel_description')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
