<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('promocodes', function (Blueprint $table) {
            $table->id();
            $table->string('promocode_name', 50);
            $table->decimal('discount', 10, 2);
            $table->tinyInteger('discount_type')->unsigned()->comment('1 = flat, 2 = percentage');
            $table->date('start_date');
            $table->date('end_date');
            $table->tinyInteger('is_active')->unsigned()->comment('1 = Active, 2 = Inactive');
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('promocodes');
    }
};
