<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drivers', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid');
            $table->string('full_name', 255);
            $table->string('email', 255);
            $table->string('password', 60);
            $table->string('isd_code', 5);
            $table->string('mobile', 11);
            $table->tinyInteger('gender')->unsigned()->comment('1 = Male, 2 = Female, 3 = Prefer Not To Say');
            $table->string('profile_image', 100)->nullable();
            $table->string('remember_token', 100)->nullable();
            $table->integer('otp')->nullable();
            $table->dateTime('otp_expiry_date')->nullable();
            $table->string('license_front_image', 100)->nullable();
            $table->string('license_back_image', 100)->nullable();
            $table->string('senbird_chat_id', 100);
            $table->string('stripe_id', 100);
            $table->tinyInteger('push_notification_accept')->unsigned()->default(0)->comment('1 = Accepted, 2 = Not Accepted');
            $table->tinyInteger('online_status')->unsigned()->default(0)->comment('1 = Online, 2 = Offline');
            $table->tinyInteger('is_active')->unsigned()->comment('1 = Active, 2 = Inactive');
            $table->tinyInteger('is_profile_completed')->unsigned()->default(0)->comment('1 = Completed, 2 = Not Completed');
            $table->tinyInteger('step')->unsigned()->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drivers');
    }
};
