<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->string('apartment_name', 100);
            $table->string('street_address', 255);
            $table->string('city', 100);
            $table->string('postal_code', 10);
            $table->unsignedTinyInteger('address_type')->default(1)->comment('1 = Home, 2 = Office, 3 = Other');
            $table->decimal('add_lat', 10, 8);
            $table->decimal('add_long', 11, 8);
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_addresses');
    }
};
