<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('username', 50);
            $table->string('email')->unique()->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->string('locale', 10)->default('en');
            $table->unsignedTinyInteger('is_active')->default(1);
            $table->string('isd_code', 10)->nullable();
            $table->string('mobile', 20)->nullable();
            $table->integer('email_otp', false)->unsigned()->nullable();
            $table->timestamp('email_otp_expired_at')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->integer('mobile_otp', false)->unsigned()->nullable();
            $table->timestamp('mobile_otp_expired_at')->nullable();
            $table->timestamp('mobile_verified_at')->nullable();
            $table->string('profile_photo', 255)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
