<?php

namespace Database\Factories;

use Illuminate\Support\Str;
use Faker\Provider\en_IN\PhoneNumber;
use SpaceO\RESTAuth\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class UserFactory extends Factory
{
    protected $model = User::class;

    public function definition()
    {
        
        [$isdCode, $mobile] = $this->getMobileDetails();
        
        return [
            'name' => $this->faker->name(),
            'email' => $this->faker->email(),
            'password' => bcrypt(123456),
            'isd_code' => $isdCode,
            'mobile' => trim($mobile),
            'username' => $this->faker->userName(),
            'mobile_verified_at' => now(),
            'email_verified_at' => now(),
        ];
    }

    public function getMobileDetails()
    {
        
        $this->faker->addProvider(new PhoneNumber($this->faker));

        if (Str::startsWith($mobile = $this->faker->mobileNumber(), 0)) {
            $isdCode = '+91';
            $mobile = substr($mobile, 1);
        } else {
            $isdCode = substr($mobile, 0, 3);
            $mobile = substr($mobile, 3);
        }

        return [$isdCode, $mobile];
    }
}
