<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
        'scheme' => 'https',
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'stripe' => [
        'secret' => env('STRIPE_SECRET_KEY'),
    ],

    'sendbird' => [
        'api_token' => env('SENDBIRD_API_TOKEN'),
        'app_id' => env('SENDBIRD_APP_ID')
    ],

    'twilio' => [
        'account_sid' => env('TWILIO_SID'),
        'auth_token'  => env('TWILIO_TOKEN'),
        'twilio_number' => env('TWILIO_FROM')
    ],

    'aws' => [
        'aws_cloud_url' => env('AWS_URL')."/",
    ],

    'fcm' => [
        'fcm_api_server_url' => env('FCM_API_SERVER_URL'),
        'fcm_server_key' => env('FCM_SERVER_KEY')
    ],

    'google_map' => [
        'api_key' => env('GOOGLE_MAP_API_KEY'),
    ]
];
