<?php

use SpaceO\RESTAuth\RESTAuth;

/**
 * Author: Mohammad Haris Rajput (harishr.spaceo@gmail.com)
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Supported API Logins
    |--------------------------------------------------------------------------
    |
    | This option controls the default login types that will be used by the
    | api when an login api getting called. You may include required
    | login type which you want to be in your application.
    |
    | Supported: "email", "mobile", "username"
    | Default: "email"
    */
    'logins' => [
        'mobile'
    ],

    /*
    |--------------------------------------------------------------------------
    | Supported Reset mechanism
    |--------------------------------------------------------------------------
    |
    | Supported: "link", "otp"
    |
    */
    'reset_mode' => 'link',

    /*
    |--------------------------------------------------------------------------
    | Supported OTP Length
    |--------------------------------------------------------------------------
    |
    | Supported: 6, 4
    | Default: 6
    */
    'otp_length'=> 4,
    'air_otp_length'=> 6,
    
    /**
     * Time in minutes after which mobile OR email OTP will be expire.
     */
    'otp_expires_in'=> 10,
    
    'locales'=> [
        'en'
    ],

    /*
    |--------------------------------------------------------------------------
    | Models
    |--------------------------------------------------------------------------
    |
    | If you want your models to be use for this library then change the below path to your model.
    | 
    */
    'models' => [
        
        'user'=> \App\Models\User::class,
        
        'setting'=> \App\Models\Setting::class,
        
        'content_page'=> \App\Models\ContentPage::class,
        
        'social_login'=> \App\Models\SocialLogin::class,

        'app_version_log'=> \App\Models\AppVersionLog::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | List of un supported apis.
    |--------------------------------------------------------------------------
    |
    | Not Supported: "LOGIN"
    | Not in use yet.
    */
    'except_apis' => [
        // RESTAuth::LOGIN_REGISTER_LOGOUT,
        // RESTAuth::SOCIAL_LOGIN,
        // RESTAuth::FORGOT_PASSWORD,
        // RESTAuth::CONTENT_PAGE,
        // RESTAuth::SEND_AND_VERIFY_OTP,
        // RESTAuth::UPDATE_PASSWORD,
        // RESTAuth::UPDATE_LOCALE,
        // RESTAuth::PAST_LOGOUT,
        // RESTAuth::USER_PROFILE,
        // RESTAuth::SETTING,
    ],

    /**
     * In Minutes
     */
    'refresh_token_life'=> env('REFRESH_TOKEN_LIFE', 4320),
];
