<?php

use App\Models\Notification;
use App\Models\PersonalAccessToken;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Ramsey\Uuid\Uuid;
use Illuminate\Support\Facades\Log;
//calculate the miles of booking
if (!function_exists('calculateDistanceInMiles')) {
    function calculateDistanceInMiles($lat1, $lon1, $lat2, $lon2, $unit = 'N')
    {
        if (($lat1 == $lat2) && ($lon1 == $lon2)) {
            return 0;
        } else {
            $theta = $lon1 - $lon2;
            $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
            $dist = acos($dist);
            $dist = rad2deg($dist);
            $miles = $dist * 60 * 1.1515;
            $unit = strtoupper($unit);

            if ($unit == "K") {
                $miles = ($miles * 1.609344);
            } else if ($unit == "N") {
                $miles = ($miles * 0.8684);
            }
            return round($miles, 2);
        }
    }
}

if (!function_exists('formatDate')) {
    function formatDate($dateString)
    {
        $carbonDate = Carbon::parse($dateString);
        return $carbonDate->format('D, j M | h:i A');
    }
}

if (!function_exists('quoteDate')) {
    function quoteDate($dateString)
    {
        $carbonDate = Carbon::parse($dateString);
        return $carbonDate->format('d M Y , h:i A');
    }
}

if (!function_exists('getBookingStatus')) {
    function getBookingStatus($status)
    {
        switch ($status) {
            case 1:
                $booking_status = "PENDING";
                break;
            case 2:
                $booking_status = "ON THE WAY";
                break;
            case 3:
                $booking_status = "ARRIVED";
                break;
            case 4:
                $booking_status = "PICKUP";
                break;
            case 5:
                $booking_status = "STARTED";
                break;
            case 6:
                $booking_status = "COMPLETED";
                break;
            case 7:
                $booking_status = "CANCELLED";
                break;
        }
        return $booking_status;
    }
}

if (!function_exists('GetUuid')) {
    function GetUuid()
    {
        return Uuid::uuid6();
    }
}


if (!function_exists('calculateSubscriptionDates')) {
    function calculateSubscriptionDates(string $duration_type, int $duration): array
    {
        $startDate = now();
        $endDate = now();

        switch ($duration_type) {
            case 'month':
                $endDate = $endDate->addMonth($duration);
                break;

            case 'year':
                $endDate = $endDate->addYear($duration);
                break;
                // Add more cases for other subscription types as needed

            default:
                // Default to 1 month if the subscription type is not recognized
                $endDate = $endDate->addMonth();
                break;
        }

        return [
            'start_date' => $startDate->toDateString(),
            'end_date' => $endDate->toDateString(),
        ];
    }
}

if (!function_exists('getCustomTimeDifference')) {
    function getCustomTimeDifference($dateTime)
    {
        $diff = Carbon::parse($dateTime)->diffInDays(Carbon::now(), false);

        if ($diff === 0) {
            return 'today';
        } elseif ($diff === 1) {
            return 'yesterday';
        } elseif ($diff > 1) {
            return $diff . ' days ago';
        }

        // If the date is in the future, return the original diffForHumans value
        return Carbon::parse($dateTime)->diffForHumans();
    }
}

if (!function_exists('getFlyingTypeText')) {
    function getFlyingTypeText($type)
    {
        $flyingTypes = config('constant.flying_types');

        foreach ($flyingTypes as $flyingType) {
            if ($flyingType['type'] == $type) {
                return $flyingType['text'];
            }
        }

        return null; // Handle the case where the type is not found
    }
}

/*
  Send push to IOS
 */
if (!function_exists('sendPushIOS')) {
    function sendPushIOS($registrationId, $msgData)
    {
        $fields['data'] = [
            // 'title' => $msgData['title'],
            // 'body' => $msgData['body'],
            // 'badge' => !empty($msgData['badge']) ? $msgData['badge'] : 0,
            // 'sound' => !empty($msgData['sound']) ? $msgData['sound'] : 'default',
            // 'icon' => '', //Yii::$app->params['LOGO_URL']
            'type' => $msgData['type'],
            'id' => !empty($msgData['id']) ? $msgData['id'] : '',
        ];
        $fields['notification'] = [
            'title' => $msgData['title'],
            'body' => $msgData['body'],
            'badge' => !empty($msgData['badge']) ? $msgData['badge'] : 0,
            'sound' => !empty($msgData['sound']) ? $msgData['sound'] : 'default',
            'icon' => '', //Yii::$app->params['LOGO_URL']
            // 'type' => $msgData['type'],
            // 'id' => !empty($msgData['iUserId']) ? $msgData['iUserId'] : '',
        ];

        // $fields['notification'] = [
        //     'title' => $msgData['title'],
        //     'body' => $msgData['body'],
        //     'badge' => $msgData['badge'],
        //     'sound' => !empty($msgData['sound']) ? $msgData['sound'] : 'default',
        //     'icon' => '', //Yii::$app->params['LOGO_URL']
        // ];
        // $fields['data'] = [
        //     'type' => $msgData['type'],
        //     'id' => !empty($msgData['id']) ? $msgData['id'] : '',
        // ];
        return pushCurlCall($registrationId, $fields);
    }
}
/*
  Send push to Android
 */
if (!function_exists('sendPushAndroid')) {
    function sendPushAndroid($registrationId, $msgData)
    {
        $fields['data'] = [
            'title' => $msgData['title'],
            'body' => $msgData['body'],
            'badge' => !empty($msgData['badge']) ? $msgData['badge'] : 0,
            'sound' => !empty($msgData['sound']) ? $msgData['sound'] : 'default',
            'icon' => '', //Yii::$app->params['LOGO_URL']
            'type' => (int)$msgData['type'],
            'id' => !empty($msgData['id']) ? (int)$msgData['id'] : 0,
        ];
        $fields['notification'] = [
            'title' => $msgData['title'],
            'body' => $msgData['body'],
            'badge' => !empty($msgData['badge']) ? $msgData['badge'] : 0,
            'sound' => !empty($msgData['sound']) ? $msgData['sound'] : 'default',
            'icon' => '', //Yii::$app->params['LOGO_URL']
            'type' => (int)$msgData['type'],
            'id' => !empty($msgData['id']) ? (int)$msgData['id'] : 0,
        ];
        return pushCurlCall($registrationId, $fields);
    }
}
/*
  Curl call
 */
if (!function_exists('pushCurlCall')) {
    function pushCurlCall($registrationId, $fields)
    {
        $url = config('services.fcm.fcm_api_server_url');
        if (is_array($registrationId)) {
            $fields['registration_ids'] = $registrationId;
        } else {
            $fields['to'] = $registrationId;
        }
        $headers = [
            'Authorization: key=' . config('services.fcm.fcm_server_key'),
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);         // Disabling SSL Certificate support temporarly
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($ch);
        curl_close($ch);
        // Log::warning($result);
        return ($result) ? 1 : 0;
    }
}

if (!function_exists('sendPushNotification')) {
    function sendPushNotification($senderId, $reciverId, $title, $message, $id = null, $type = 'promotional', $sender_type, $receiver_type, $noti_type)
    {
        $msgData = [
            'title' => $title,
            'body' => $message,
            'badge' => 0,
            'sound' => 'default',
            'type' => $type,
            'id' => $id,
        ];
        $device = PersonalAccessToken::where("tokenable_id", $reciverId)->first();
        if ($device) {

            if ($device->device_type == 1) {

                $sendpush = sendPushIOS($device->fcm_key, $msgData);
            } else {
                $sendpush = sendPushAndroid($device->fcm_key, $msgData);
            }

            if ($sendpush) {
                Notification::create([
                    'notification_title' => $title,
                    'notification_desc' => $message,
                    'notification_object_id' => $id,
                    'notification_object_type' => $type,
                    'sender_id' => $senderId,
                    'receiver_id' => $reciverId,
                    'sender_type' => $sender_type,
                    'receiver_type' => $receiver_type,
                    'type' => $noti_type
                ]);
            }
        }
    }
}

if (!function_exists('calculateDaysDifference')) {
    function calculateDaysDifference($date1, $date2)
    {
        $dateTime1 = new DateTime($date1);
        $dateTime2 = new DateTime($date2);

        $interval = $dateTime1->diff($dateTime2);

        return $interval->days;
    }
}
if (!function_exists('getJetTypeText')) {
    function getJetTypeText($type)
    {
        $jetTypes = collect(config('constant.jet_types'));

        $jetType = $jetTypes->first(function ($item) use ($type) {
            return $item['type'] === $type;
        });

        return $jetType ? $jetType['text'] : null;
    }
}

if (!function_exists('getRoutingTypeText')) {
    function getRoutingTypeText($type)
    {
        $routingTypes = collect(config('constant.routing_types'));

        $routingType = $routingTypes->first(function ($item) use ($type) {
            return $item['type'] === $type;
        });

        return $routingType ? $routingType['text'] : null;
    }
}


if (!function_exists('getdefaultGrathData')) {
    function getdefaultGrathData($filterType): Collection
    {
        $data = new Collection();
        switch ($filterType) {
            case 1:
                $startDate = Carbon::now()->startOfWeek();
                $endDate = Carbon::now()->endOfWeek();
                $groupByFormat = 'D'; // Group data by day of the week (e.g., Monday, Tuesday)
                break;
            case 2:
                $startDate = Carbon::now()->startOfMonth();
                $endDate = Carbon::now()->endOfMonth();
                $groupByFormat = 'W'; // Group data by month name and week number (e.g., January Week 1, January Week 2)
                break;
                break;
            case 3:
                $startDate = Carbon::now()->startOfYear();
                $endDate = Carbon::now()->endOfYear();
                $groupByFormat = 'M'; // Group data by year
                break;
            default:
                // Invalid filter type, handle the error as needed
                return $data;
        }
        $currentDate = $startDate->copy();

        if ($filterType == 1) {
            while ($currentDate <= $endDate) {
                $formattedDate = Carbon::parse($currentDate)->format($groupByFormat);
                $data[] = $formattedDate;
                $currentDate->addDays(1);
            }
        }

        if ($filterType == 2) {
            $i = 0;
            while ($currentDate <= $endDate) {
                $i++;
                $formattedDate = Carbon::parse($currentDate)->format($groupByFormat);
                $data[] = 'W-' . $i;
                $currentDate->addWeek();
            }
        }
        if ($filterType == 3) {

            while ($currentDate <= $endDate) {
                $formattedDate = Carbon::parse($currentDate)->format($groupByFormat);
                $data[] = $formattedDate;
                $currentDate->addMonth();
            }
        }

        return $data;
    }
}

if (!function_exists('getCardImage')) {
    function getCardImage($brand)
    {
        switch ($brand) {
            case 'Visa':
                $cardImage = asset('images/cards/visa.png');
                break;
            case 'Mastercard':
                $cardImage = asset('images/cards/mastercard.png');
                break;
            case 'American Express':
                $cardImage = asset('images/cards/amex.png');
                break;
            case 'Diners Club':
                $cardImage = asset('images/cards/diners-club.png');
                break;
            case 'Discover':
                $cardImage = asset('images/cards/discover.png');
                break;
            case 'JCB':
                $cardImage = asset('images/cards/jcb.png');
                break;

            default:
                $cardImage = asset('images/cards/code.png');
        }
        return $cardImage;
    }
}

if (!function_exists('getJetPrice')) {
    function getJetPrice($type)
    {
        $jetTypes = collect(config('constant.jet_types'));

        $jetType = $jetTypes->first(function ($item) use ($type) {
            return $item['type'] === $type;
        });

        return $jetType ? $jetType['price'] : 0;
    }
}

if (!function_exists('getAirBookingStatus')) {
    function getAirBookingStatus($status)
    {
        switch ($status) {
            case 1:
                $booking_status = "PENDING";
                break;
            case 2:
                $booking_status = "Upcoming";
                break;
            case 3:
                $booking_status = "COMPLETED";
                break;
            case 4:
                $booking_status = "CANCELLED";
                break;
        }
        return $booking_status;
    }
}
