<?php

namespace App\Services;
use Illuminate\Http\Request;

class UpdateSocialiteInfo
{

    public function __invoke($user, Request $request, array $socialData)
    {
        
        $user->socialLogins()->updateOrCreate([
            'user_id'=> $user->getKey(),
            'social_id'=> $request->social_id,
            'type'=> $this->socialTypeIdentifier($request->social_type),
        ],[
            'data'=> $socialData,
        ]);
    }

    public function create($user, $request)
    {
        
        $user->socialLogins()->create([
            'user_id'=> $user->getKey(),
            'social_id'=> $request->social_id,
            'type'=> $this->socialTypeIdentifier($request->social_type),
        ]);
    }

    public function socialTypeIdentifier(string $type)
    {
        return match($type) {
            '1' => 1,
            '2' => 2,
            '3' => 3,
            '4' => 4,
        };
    }
}
