<?php

namespace App\Services;

use Stripe\Stripe;
use Stripe\Customer;
use Stripe\Token;
use Stripe\PaymentIntent;;
use Stripe\PaymentMethod;
use Illuminate\Support\Str;
use Stripe\Account;
use Stripe\Plan;
use Stripe\Product;
use Stripe\Subscription;


class StripeService
{
    public function __construct()
    {
        Stripe::setApiKey(config('services.stripe.secret'));
    }

    public function createCustomer($email, $name, $type)
    {
        if ($type == 1) {
            $stripeCustomer = Customer::create([
                'email' => $email,
                'name' => $name,
                // Add any additional customer data as needed
            ]);
        } else {
            $account_data = [
                'individual' => [
                    'first_name' => $name,
                    'last_name' => $name,
                    'email' => $email,
                    // Other individual details
                ],
                'email' => $email,
                'country' => 'US',
                'type' => 'custom',
                'business_type' => 'individual',
                "business_profile" => [
                    "name" => $name,
                    "url" => "www.4u.com"
                ],
                'capabilities' => [
                    'transfers' => ['requested' => true],
                ],
                'tos_acceptance' => [
                    'date' => time(),
                    'ip' => $_SERVER['REMOTE_ADDR'],
                ],
            ];
            $stripeCustomer = Account::create($account_data);
        }


        return $stripeCustomer;
    }

    public function createCard($customerId, $token)
    {

        $paymentMethod = PaymentMethod::retrieve(
            $token,
        );
        $stripeCustomer = $paymentMethod->attach([
            'customer' => $customerId,
        ]);

        return $stripeCustomer;
    }

    public function deleteCard($customerId, $cardToken)
    {
        $paymentMethod = PaymentMethod::retrieve(
            $cardToken,
        );
        $stripeCustomer = $paymentMethod->detach();
        return $stripeCustomer;
    }

    public function createPaymentMethod($cardNumber, $expiryMonth, $expiryYear, $cvc)
    {
        $payment_method = PaymentMethod::create([
            'type' => 'card',
            'card' => [
                'number' => $cardNumber,
                'exp_month' => $expiryMonth,
                'exp_year' => $expiryYear,
                'cvc' => $cvc,
            ],
        ]);
        return $payment_method;
    }

    public function createPaymentIntent($amt, $token, $acc_id, $customer_id, $payment_type)
    {
        // dd($token);
        $transaction_id = Str::random(18);
        $response_data = PaymentIntent::create([
            'amount' => $amt * 100,
            'currency' => "usd",
            'payment_method_types[]' => 'card',
            'payment_method' => $token,
            'confirm' => 'true',
            'capture_method' => 'automatic',
            'confirm' => true,
            'payment_method_options[card][request_three_d_secure]' => 'automatic',
            'description' => $payment_type,
            "transfer_data" => [
                'amount' => $amt * 100,
                'destination' => $acc_id,
            ],
            'customer' => $customer_id

            // Add any additional charge data as needed
        ]);
        return $response_data;
    }

    public function getPlan()
    {
        try {
            $plans = Plan::all();
            return $plans;
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    public function subscribeDriver($customerId, $planId, $source)
    {

        $response_data = Subscription::create([
            'customer' => $customerId,
            'items' => [
                [
                    'price' => $planId,
                ],
            ],
            'default_payment_method' => $source
        ]);
        return $response_data;
    }

    public function getPlanDetail($planId)
    {
        $response_data = $plan = Plan::retrieve($planId);
        return $response_data;
    }

    public function addCard($customerId, $token)
    {
        $stripeCustomer = Customer::createSource(
            $customerId,
            ['source' => $token]
            // Add any additional customer data as needed
        );

        return $stripeCustomer;
    }

    public function getCardList($customerId)
    {
        $stripeCustomer = Customer::allPaymentMethods(
            $customerId,  
            [
            'type' => 'card',
            'limit' => 100,
            ]
        );
        return $stripeCustomer;
    }

    public function getBankList($customerId)
    {
        $stripeCustomer = Account::allExternalAccounts(
            $customerId,  
            [
            'object' => 'bank_account',
            'limit' => 100,
            ]
        );
        return $stripeCustomer;
    }

    public function deleteBank($customerId, $bankToken)
    {
        $stripeCustomer = Account::deleteExternalAccount($customerId, $bankToken);

        return $stripeCustomer;
    }

    public function makeDefaultBank($customerId, $bankToken)
    {
        $stripeCustomer = Account::updateExternalAccount($customerId, $bankToken, ['default_for_currency' => true]);

        return $stripeCustomer;

    }

    public function subscribeAirtransport($customerId, $planId, $source)
    {

        $response_data = Subscription::create([
            'customer' => $customerId,
            'items' => [
                [
                    'price' => $planId,
                ],
            ],
            'default_source' => $source
        ]);
        return $response_data;
    }

    public function getProduct()
    {
        try {
            $plans = Product::all();
            return $plans;
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
