<?php
namespace App\Services;

use Carbon\Carbon;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Support\Str;

class SendbirdService
{

    public function createUser($userId, $nickname, $profileUrl)
    {
        try{
        $random=Str::random(10);
        $client = new Client();
        $url = "https://api-".config('services.sendbird.app_id').".sendbird.com/v3/users";
        $response = $client->request('POST', $url, [
            'headers' => [
                'Content-Type' => 'application/json',
                'Api-Token' => config('services.sendbird.api_token'),
            ],
            'json' => [
                'user_id' => $userId."_".$random,
                'nickname' => $nickname,
                'profile_url' => $profileUrl,
            ],
        ]);

        $body = $response->getBody()->getContents();
        $responseData = json_decode($body, true);

        return $responseData;

        }catch(Exception $e){
            return $e->getMessage();
        }
    }

    /**
     * Get login user's channel list
     */
    public function getChatUser($userId)
    {
      try{

      
            $client = new Client();
            $url = "https://api-".config('services.sendbird.app_id').".sendbird.com/v3/users/".$userId."/my_group_channels?show_member=true&show_empty=true&members_in=".$userId;
        
            $response = $client->request('GET', $url, [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Api-Token' => config('services.sendbird.api_token'),
                ],
            ]);
            $body = $response->getBody()->getContents();
            $responseData = json_decode($body, true);
            $chatUsers = [];
            foreach($responseData['channels'] as $channel)
            {  
                //  dd($responseData['channels']);
                if(isset($channel['members'])){
                    $memberCollection =  collect($channel['members']);
                    $memberCollection = $memberCollection->filter(function ($item, $key) use ($userId) {
                        return $item['user_id'] != $userId;
                    });
                    $members = $memberCollection->first();
                }
            
                $last_message_time = $channel['last_message']['created_at'] ?? ''; //last message timestamp
                $chatUsers[] = [
                    'last_message' => isset($channel['last_message']['message']) ? $channel['last_message']['message'] : (isset($channel['last_message']['type'])  == 'FILE' ? $channel['last_message']['file']['name'] : 'No message'),
                    'timestamp'    => $this->timeAgo($last_message_time), //Carbon::parse($last_message_time)->format('H:i:s'),
                    'channel_id'   => $channel['channel_url'],
                    'image'        => isset($members) ? $members['profile_url'] : $channel['cover_url'],
                    'name'         => isset($members) ? ucfirst($members['nickname']) : ucfirst($channel['name']),
                    'chat_user_id' => isset($members) ? $members['user_id'] : '',
                    'is_muted'     => isset($members) ? $members['is_muted'] : '',
                    'is_banned'    => $channel['is_muted'],
                ];
            }
            return $chatUsers;

        }catch(Exception $e){
            return $e->getMessage();
        }
    }

    public function getChatMessages($channelId)
    {
        try{
            $allMessageData = []; 
            $client = new Client();
            $url = "https://api-".config('services.sendbird.app_id').".sendbird.com/v3/group_channels/".$channelId."/messages?message_ts=1703166399&prev_limit=10&next_limit=200";
            $response = $client->request('GET', $url, [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Api-Token' => config('services.sendbird.api_token'),
                ],
            ]);

            $body = $response->getBody()->getContents();
            $responseData = json_decode($body, true);
            // $access_token = '';
            // if($responseData['messages'][0]['user']){
            //     $access_token =  $this->getUser($responseData['messages'][0]['user']['user_id']);
            // }
          
            foreach($responseData['messages'] as $message)
            {   
                
                 if($message['type'] !== "ADMM")
               {
                    $message_data['message_id'] = $message['message_id'];
                    $message_data['message'] =  (isset($message['file']['name'])  == 'FILE' ? $message['file']['name'] :$message['message']);
                    $message_data['created_at'] = $message['created_at'];
                    $message_data['user_id'] = $message['user']['user_id'];
                    $message_data['type'] = $message['type'];
                    $message_data['file'] = isset($message['file']) ? $message['file'] :'';
                    // if(!empty($message['file'])){
                    //     $message_data['file']['url'] =   $message['file']['url'].'?auth='.$access_token;
                    // }
                    $allMessageData[] = $message_data;
                 }
                
            }
        //  dd($allMessageData);
            return $allMessageData;
        }catch(Exception $e){
            dd($e);
            return ['success' => 'false' ,'msg' => 'Network error please try again.'];
        }
    }



    public function timeAgo($dateParam)
    {
        if (!$dateParam) {
            return ' ';
        }
        $date = \DateTime::createFromFormat('U.u', sprintf('%d.%d', $dateParam / 1000, $dateParam % 1000 * 1000));
         
        $now = new \DateTime();
        $seconds = $now->getTimestamp() - $date->getTimestamp();

        $minutes = floor($seconds / 60);
        $hours = floor($minutes / 60);
        $days = floor($hours / 24);

        if ($hours < 24 && $date->format('Y-m-d') === $now->format('Y-m-d')) {
            return $date->format('H:i');
        } elseif ($hours < 48) {
            return 'Yesterday';
        } elseif ($hours < 168) {
            return $date->format('l');
        } else {
            return $date->format('M d, Y');
        }

    }

}