<?php

namespace App\Services\MediaLibrary;

trait MediaExpectedTrait
{
    
    public int $height;
    public int $width;
    public string $path;
    public string $extension;
    
    /**
     * This expects the array of pixels which determine the expected image to be as result. 
     *
     * @param array $size [$height, $width]
     * @return self
     */
    public function expectedSize(array $size) : self
    {
        [$this->height, $this->width] = $size;
        return $this;
    }

    public function expectedPath(string $path) : self
    {
        $this->path = $path;
        return $this;
    }

    public function expectedExtension(string $extension) : self
    {
        $this->extension = $extension;
        return $this;
    }
}
