<?php

namespace App\Services\MediaLibrary;

use Iterator;

class MediaCollection implements Iterator {
    
    public function __construct(
        public array $images
    ){}

    public function current()
    {
        return current($this->images);
    }
    
    public function next()
    {
        next($this->images);
    }

    public function key()
    {
        return key($this->images);
    }

    public function valid()
    {
        return current($this->images) !== false;
    }

    public function rewind()
    {
        return reset($this->images);
    }
}