<?php

namespace App\Services\MediaLibrary;

use Illuminate\Http\UploadedFile;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Image as ImageInstance;
use App\Services\MediaLibrary\MediaExpectedTrait;

class Media {
    
    use MediaExpectedTrait;
    
    public string $name;

    public function __construct(
        public UploadedFile $file
    ){
        $this->image = Image::make($file);
        $this->extension = $file->getClientOriginalExtension();
    }

    public function upload() : self
    {
        $this->name = uniqid() . '.' . $this->extension;

        Storage::put(
            $this->purifyThePath(),
            $this->resize()->stream()->detach()
        );

       return $this;
    }

    public function purifyThePath() : string
    {
        return str_replace('//', '/', $this->path ?? '' . '/' . $this->name);
    }

    public function resize(): ImageInstance 
    {
        return $this->image->encode($this->extension)
                ->resize(
                    $this->width ?? $this->image->height(), 
                    $this->height ?? $this->image->width(), 
                    function ($constraint) {
                        $constraint->aspectRatio();
                        $constraint->upsize();
                    }
                );
    }
}