<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema; // <-- Add this to support default string length
use Illuminate\Support\Facades\URL;    // <-- Optional, for cleaner URL usage

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register()
    {
        // You can register bindings or singletons here if needed
    }

    /**
     * Bootstrap any application services.
     */
    public function boot()
    {
        // ✅ Fix for MySQL key length error during migration
        Schema::defaultStringLength(191);

        // 🌐 Force HTTPS scheme in URLs (for secure environments)
        if (
            (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] === 'on' || $_SERVER['HTTPS'] == 1)) ||
            (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https')
        ) {
            URL::forceScheme('https');
        }
    }
}
