<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Log;
use NotificationChannels\Fcm\FcmChannel;
use NotificationChannels\Fcm\FcmMessage;
use NotificationChannels\Fcm\Resources\AndroidConfig;
use NotificationChannels\Fcm\Resources\AndroidFcmOptions;
use NotificationChannels\Fcm\Resources\AndroidNotification;
use NotificationChannels\Fcm\Resources\ApnsConfig;
use NotificationChannels\Fcm\Resources\ApnsFcmOptions;
use NotificationChannels\Fcm\Resources\Notification as NotificationChannel;
use NotificationChannels\Fcm\Resources\Notification as FcmNotification;
class AdminPushNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function via($notifiable)
    {
        return [FcmChannel::class];
    }

    // protected $notificationData;
    protected $notification;

    public function __construct($notification)
    {
        $this->notification = $notification;
    }

    public function toFcm($notifiable)
    {
        Log::info('$receiverUsers7');


        $config  = [];
        if($this->notification['type'] != 'airtransport'){
            if(isset($notifiable->personalAccess) && $notifiable->personalAccess->device_type == 2){
                $config = [
                    'android' => [
                        'fcm_options' => [
                            'analytics_label' => 'analytics',
                        ],
                    ]
                    ];
            }else if(isset($notifiable->personalAccess) && $notifiable->personalAccess->device_type == 1){
                $config = [
                    'apns' => [
                        'fcm_options' => [
                            'analytics_label' => 'analytics_ios',
                        ],
                    ],
                ];
            }
        }
          
        $resopnse = (new FcmMessage(notification: new FcmNotification(
            title: $this->notification['title'],
            body: $this->notification['message'],
        )))
        ->data([   
            'title' => $this->notification['title'],
            'body' => $this->notification['message']
        ])
        ->custom( $config);
       

        Log::info('receiverUsers8' );
        return $resopnse;
    }


    public function fcmProject($notifiable, $message)
    {
        return 'u-app-2071c'; // name of the firebase project to use
    }
}