<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehicleInfo extends Model
{
    use HasFactory;

    protected $fillable = [
        'driver_id',
        'vehicle_type',
        'plate_number',
        'model_name',
        'model_no',
        'color',
        'identification_no',
        'model_year',
        'seating_capacity',
        'registration_proof_file',
        'insurance_proof_file',
        'vehicle_front_image',
        'vehicle_back_image',
        'vehicle_right_image',
        'vehicle_left_image',
    ];

    public function car()
    {
        return $this->belongsTo(Car::class, 'vehicle_type', 'id');
    }
}
