<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSubscription extends Model
{
    use HasFactory;
    protected $fillable = ['subscribable_type','subscribable_id','subscription_id','start_date','end_date','plan_price','subscription_type'];

    public function subscription()
    {
        return $this->belongsTo(Subscription::class);
    }

    public function subscribable() {
        return $this->morphTo();
    }

}
