<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class UserDevice extends Model
{
    use HasFactory;

    protected $fillable = [

        'deviceable_id',
        'deviceable_type',
        'device_type',
        'device_token',
        'device_unique_id',
        'os_version',
        'device_name',
        'latitude',
        'longitude',
        'user_type',
    ];

    /**
     * Get the parent deviceable model (user or driver).
     */
    public function deviceable(): MorphTo
    {
        return $this->morphTo();
    }
}
