<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserAddress extends Model
{
    use HasFactory, SoftDeletes;
    protected $dates = ['deleted_at'];
    protected $fillable = [ 'user_id','apartment_name','street_address','city','postal_code','address_type','add_lat','add_long'];
    protected $casts = [
        'add_lat' => 'double',
        'add_long' => 'double',
    ];
}
