<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Terminal extends Model
{
    use HasFactory, SoftDeletes;
    protected $dates = ['deleted_at'];
    protected $fillable=['air_transportation_id','pickup_location','dropoff_location','terminal_type','is_active'];

    protected $attributes = [
        'is_active' => 1,
    ];

    public function airTransportation() {
        return $this->belongsTo(AirTransportation::class);
    }

    public function terminalImages()
    {
        return $this->hasMany(TerminalImage::class);
    }
}
