<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'key',
        'values',
    ];

    protected $casts = [
        'values'=> 'array',
    ];

    const APP_VERSIONS = 'app_versions';
    const WAITING = 'waiting';
    const RADIUS = 'radius';
    const CANCELLATION = 'cancellation';

    const IOS = 'ios';
    const ANDROID = 'android';

    public static function getVersionCodeRawQuery(string $platform)
    {
        return DB::raw('
            json_extract(
                json_extract(
                    `values`, 
                    json_unquote(
                        json_search(
                            json_extract(
                                `values`, 
                                "$[*].platform"
                            ), "one", "'.$platform.'"
                        )
                    )
                ), 
            "$.version"
            )
        ');
    }

    public static function whereVersionShouldBeGreater(string $platform, int $version)
    {
        return self::where('key', self::APP_VERSIONS)
                    ->where(self::getVersionCodeRawQuery($platform), '<=', $version);
    }
}
