<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Review extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = ['user_id', 'review', 'rating', 'tip', 'reviewable_id', 'booking_id', 'reviewable_type', 'review_type'];

    /**
     * Get the parent imageable model (user or post).
     */
    public function reviewable(): MorphTo
    {
        return $this->morphTo();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function air_transportation_booking()
    {
        return $this->belongsTo(AirTransportationBooking::class, 'reviewable_id');
    }
    public function booking() {
        return $this->belongsTo(Booking::class);
    }
    
}
