<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quote extends Model
{
    use HasFactory;

    const ACCEPTED = 1;
    const COUNTER = 2;
    const REJECTED = 3;
    const AUTO_REJECTED = 4;

    protected $fillable = ['air_transportation_booking_id', 'air_transportation_id', 'company_quote_price', 'user_quote_price', 'quote_status', 'quote_date_time'];

    public function air_transportations()
    {
        return $this->belongsTo(AirTransportation::class, 'air_transportation_id');
    }

    public function air_transportation_bookings()
    {
        return $this->belongsTo(AirTransportationBooking::class, 'air_transportation_booking_id');
    }
}
