<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pilot extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = ['uuid','air_transportation_id','pilot_name','pilot_mobile','nationality','experience','license_front_image','license_back_image','profile_image','is_active'];

    protected $attributes = [
        'is_active' => 1,
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            // Set UUID before creating a new model
            $model->uuid = GetUuid();
        });
    }

    public function airTransportation() {
        return $this->belongsTo(AirTransportation::class);
    }
}
