<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Parcel extends Model
{
    protected $fillable = [
        'sender_id', 'driver_id', 'pickup_address', 'delivery_address', 'status'
    ];

    public function sender() {
        return $this->belongsTo(User::class, 'sender_id');
    }

    public function driver() {
        return $this->belongsTo(Driver::class, 'driver_id');
    }
}
