<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Jet extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = ['uuid','air_transportation_id','jet_name','routing_type','total_capacity','jet_type','is_active'];

    protected $attributes = [
        'is_active' => 1,
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            // Set UUID before creating a new model
            $model->uuid = GetUuid();
        });
    }

    public function jetImages()
    {
        return $this->hasMany(JetImage::class);
    }

    public function airTransportation() {
        return $this->belongsTo(AirTransportation::class);
    }
}
