<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Car extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [ 'uuid', 'car_type_name', 'car_capacity', 'car_description', 'car_image'];

    protected $attributes = [
        'is_active' => 1,
    ];

    public function booking()
    {
        return $this->hasOne(Booking::class);
    }
}
