<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CancelBooking extends Model
{
    use HasFactory;
    protected $fillable = ['booking_id','air_transportation_booking_id','cancel_reason_id','cancel_description','cancelled_by','type'];

    public function booking()
    {
        return $this->belongsTo(Booking::class, 'booking_id');
    }

    public function cancelreason()
    {
        return $this->belongsTo(CancelReason::class, 'cancel_reason_id');
    }

    public function airtransportbooking()
    {
        return $this->belongsTo(AirTransportationBooking::class, 'air_transportation_booking_id');
    }
}
