<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'booking_no', 
        'driver_id',
        'booking_date_time',
        'booking_status',
        'car_id',
        'payment_card_id',
        'is_scheduled',
        'schedule_fire_time',
        'schedule_date', 
        'schedule_time',
        'promocode_id',
        'promocode_amount',
        'booking_amount',
        'user_price',
        'cancel_reason_id',
        'cancel_description'
    ];

    public function bids()
    {
        return $this->hasMany(Bid::class);
    }

    public function bid()
    {
        return $this->hasOne(Bid::class);
    }


    public function driver()
    {
        return $this->belongsTo(Driver::class);
    }

    public function bookingaddress()
    {
        return $this->hasOne(BookingAddress::class);
    }

    public function cancelbooking()
    {
        return $this->hasOne(CancelBooking::class, 'booking_id');
    }


    public function car()
    {
        return $this->belongsTo(Car::class);
    }

    public function payments()
    {
        return $this->hasMany(BookingPayment::class, 'booking_id');
    }

    public function users()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function promocode()
    {
        return $this->belongsTo(Promocode::class);
    }

    public function review()
    {
        return $this->hasOne(Review::class, 'booking_id');
    }


    

}
