<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphOne;

class AirTransportationBooking extends Model
{
    use HasFactory;
    protected $fillable = [
        'booking_no',
        'user_id',
        'air_transportation_id',
        'pickup_location',
        'dropoff_location',
        'departure_date_time',
        'arrival_date_time',
        'flying_type',
        'comment',
        'adult',
        'child',
        'infants',
        'trip_type',
        'status',
        'booking_price',
    ];

    public function quotes()
    {
        return $this->hasMany(Quote::class);
    }


    public function quote()
    {
        return $this->hasOne(Quote::class);
    }

    public function air_transportations()
    {
        return $this->belongsTo(AirTransportation::class,'air_transportation_id');
    }

    public function getTripType()
    {
        return ($this->trip_type == 1) ? 'oneway' : 'round';
    }

    public function users()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function review(): MorphOne
    {
        return $this->morphOne(Review::class, 'reviewable');
    }

    public function cancel_booking()
    {
        return $this->hasOne(CancelBooking::class, 'air_transportation_booking_id');
    }
}


